﻿<?xml version="1.0" encoding="utf-8" ?> 

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>

	<xsl:output method='html'/>



	<xsl:include href="../../apt/views/multisectionspreadsheet.xslt"/>



	<xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template>

	

	<xsl:strip-space elements="*"/>



	<xsl:variable name="subTotalTime" select='number(@cultimer)'/>



	<xsl:template match='node()[@type="profilernode"]'>

		<xsl:call-template name="multisection_start">

			<xsl:with-param name="sections">

				<section name="node_desc"><xsl:copy-of select="."/></section>

				<section name="callers"><xsl:copy-of select="./*[@type='caller']"/></section>

				<section name="callees"><xsl:copy-of select="./*[@type='callee']"/></section>

			</xsl:with-param>

		</xsl:call-template>

	</xsl:template>

	

	<xsl:template name="section_title">

		<xsl:param name="section_name"/>

		<xsl:choose>

			<xsl:when test="string($section_name) = 'node_desc'">

				Function Detail [<xsl:value-of select='string(*/@funcname)'/>]

			</xsl:when>

			<xsl:when test="string($section_name) = 'callers'">Callers</xsl:when>

			<xsl:when test="string($section_name) = 'callees'">Callees</xsl:when>

		</xsl:choose>

	</xsl:template>

	

	<xsl:template name="section_content">

		<xsl:param name="section_name"/>

		<xsl:choose>

			<xsl:when test="string($section_name) = 'node_desc'">

				<table class="profilernode_description" cellpading="0" cellspacing="0">

					<tr>

						<td class="profilernode_description_field">URL</td>

						<td class="profilernode_description_value">

							<xsl:value-of select='string(*/@codebase)'/>

						</td>

					</tr>

					<tr>

						<td class="profilernode_description_field">Total Called Counter</td>

						<td class="profilernode_description_value">

							<xsl:value-of select='number(*/@count)'/>

						</td>

					</tr>

					<tr>

						<td class="profilernode_description_field">Total Function Time</td>

						<td class="profilernode_description_value">

							<xsl:value-of select='number(*/@functimer)'/>

						</td>

					</tr>

					<tr>

						<td class="profilernode_description_field">Total Culmulative Time</td>

						<td class="profilernode_description_value">

							<xsl:value-of select='number(*/@cultimer)'/>

						</td>

					</tr>

				</table>

			</xsl:when>

			<xsl:when test="string($section_name) = 'callers'">

				<xsl:choose>

					<xsl:when test="node()[@type='caller']">

						<div class="profilernodecallerlist">

							<xsl:call-template name="spreadsheet_start">

								<xsl:with-param name="name">caller</xsl:with-param>

								<xsl:with-param name="fit_height">true</xsl:with-param>

							</xsl:call-template>

						</div>

					</xsl:when>

					<xsl:otherwise>

						None

					</xsl:otherwise>

				</xsl:choose>

			</xsl:when>

			<xsl:when test="string($section_name) = 'callees'">

				<xsl:choose>

					<xsl:when test="node()[@type='callee']">

						<div class="profilernodecalleelist">

							<xsl:call-template name="spreadsheet_start">

								<xsl:with-param name="name">callee</xsl:with-param>

								<xsl:with-param name="autofit_minheight">100</xsl:with-param>

							</xsl:call-template>

						</div>

					</xsl:when>

					<xsl:otherwise>

						None

					</xsl:otherwise>

				</xsl:choose>

			</xsl:when>

		</xsl:choose>

	</xsl:template>

	

	<xsl:template name="spreadsheet_columns_def">

		<xsl:param name="hidden"/>

		<xsl:param name="sheet"/>

		<xsl:if test='$sheet[.="caller"]'>

			<xsl:call-template name="spreadsheet_column">

				<xsl:with-param name="name">ID</xsl:with-param>

				<xsl:with-param name="width">50px</xsl:with-param>

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_column">

				<xsl:with-param name="name">Function</xsl:with-param>

				<xsl:with-param name="width">70px</xsl:with-param>

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_column">

				<xsl:with-param name="name">Counter</xsl:with-param>

				<xsl:with-param name="width">50px</xsl:with-param>

				<xsl:with-param name="type">number</xsl:with-param>

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_column">

				<xsl:with-param name="name">Function Time</xsl:with-param>

				<xsl:with-param name="width">100px</xsl:with-param>

				<xsl:with-param name="type">number</xsl:with-param>

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_column">

				<xsl:with-param name="name">Culmulative Time</xsl:with-param>

				<xsl:with-param name="type">number</xsl:with-param>

				<xsl:with-param name="width">100px</xsl:with-param>

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_column">

				<xsl:with-param name="name">URL</xsl:with-param>

				<xsl:with-param name="width">100%</xsl:with-param>

				<xsl:with-param name="minwidth">100px</xsl:with-param>

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

		</xsl:if>

		<xsl:if test='$sheet[.="callee"]'>

			<xsl:call-template name="spreadsheet_column">

				<xsl:with-param name="name">ID</xsl:with-param>

				<xsl:with-param name="width">50px</xsl:with-param>

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_column">

				<xsl:with-param name="name">Function</xsl:with-param>

				<xsl:with-param name="width">70px</xsl:with-param>

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_column">

				<xsl:with-param name="name">Counter</xsl:with-param>

				<xsl:with-param name="width">50px</xsl:with-param>

				<xsl:with-param name="type">number</xsl:with-param>

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_column">

				<xsl:with-param name="name">Culmulative Time</xsl:with-param>

				<xsl:with-param name="width">100px</xsl:with-param>

				<xsl:with-param name="type">number</xsl:with-param>

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_column">

				<xsl:with-param name="name">URL</xsl:with-param>

				<xsl:with-param name="width">100%</xsl:with-param>

				<xsl:with-param name="minwidth">100px</xsl:with-param>

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

		</xsl:if>

	</xsl:template>

	

	<xsl:template name="spreadsheet_rows_def">

		<xsl:param name="hidden"/>

		<xsl:param name="sheet"/>

		<xsl:for-each select='node()[@type=$sheet]'>

			<xsl:call-template name="spreadsheet_row">

				<xsl:with-param name="hidden" select="$hidden"/>

				<xsl:with-param name="sheet" select="$sheet"/>

			</xsl:call-template>

		</xsl:for-each>

	</xsl:template>

	

	<xsl:template name="spreadsheet_values_def">

		<xsl:param name="sheet"/>

		<xsl:attribute name="statementid">

			<xsl:value-of select="@statementid"/>

		</xsl:attribute>

		<xsl:attribute name="functimerper">

			<xsl:value-of select="round(@functimer*10000 div $subTotalTime) div 100"/>

		</xsl:attribute>

		<xsl:if test='$sheet[.="caller"]'>

			<xsl:attribute name="cultimerper">

				<xsl:value-of select="round(@cultimer*10000 div $subTotalTime) div 100"/>

			</xsl:attribute>

			<xsl:call-template name="spreadsheet_value">

				<xsl:with-param name="value" select="string(@caller)"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_value">

				<xsl:with-param name="value" select="string(@funcname)"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_value">

				<xsl:with-param name="value" select="string(@count)"/>

				<xsl:with-param name="type">number</xsl:with-param>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_value">

				<xsl:with-param name="value" select="concat(string(@functimer), ' (', round(@functimer * 10000 div $subTotalTime) div 100, '%)')"/>

				<xsl:with-param name="type">number</xsl:with-param>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_value">

				<xsl:with-param name="value" select="concat(string(@cultimer), ' (', round(@cultimer * 10000 div $subTotalTime) div 100, '%)')"/>

				<xsl:with-param name="type">number</xsl:with-param>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_value">

				<xsl:with-param name="value"><a href='javascript:' class='titoAnchor'><xsl:value-of select="@codebase"/>&#160;</a>

			</xsl:with-param>

		</xsl:call-template>

		</xsl:if>

		<xsl:if test='$sheet[.="callee"]'>

			<xsl:call-template name="spreadsheet_value">

				<xsl:with-param name="value" select="string(@callee)"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_value">

				<xsl:with-param name="value" select="string(@funcname)"/>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_value">

				<xsl:with-param name="value" select="string(@count)"/>

				<xsl:with-param name="type">number</xsl:with-param>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_value">

				<xsl:with-param name="value" select="concat(string(@cultimer), ' (', round(@cultimer * 10000 div $subTotalTime) div 100, '%)')"/>

				<xsl:with-param name="type">number</xsl:with-param>

			</xsl:call-template>

			<xsl:call-template name="spreadsheet_value">

				<xsl:with-param name="value"><a href='javascript:' class='titoAnchor'><xsl:value-of select="@codebase"/>&#160;</a></xsl:with-param>

			</xsl:call-template>

		</xsl:if>

	</xsl:template>



</xsl:stylesheet>

